/*
Basic operations. Demo for one board. 
*/
 
// ROHM IC Motor Drivers
// please define one of the following motor driver ICs
// based on the EVK model version you are using.
// Please also visit
// http://www.rohm.com/web/eu/arduino-stepper-motor-shield
// to download the latest EVK manual version.
// Please also visit
// http://www.rohm.com/web/eu/search/parametric/-/search/Stepping%20Motor
// to download the latest datasheet version of the motor driver IC you are evaluating.

//#define BD63510AEFV  
//#define BD63520AEFV 
//#define BD63524AEFV 
//#define BD63710AEFV  
//#define BD63715AEFV 
#define BD63720AEFV  
//#define BD6425EFV 
//#define BD63843EFV 
//#define BD63847EFV
 
#include <ROHM_Steppers.h>

// initialize the ROHM Steppers libs for MASTER board 
// and NOT ACTIVE(OPEN), RESET, FULL_STEP, CW 
// half clock perid 1000 us by default

ROHM_Stepper RS(ONE);

void setup()
{
	// change pin state
    RS.ENABLE(ACTIVE);  // OPEN->ACTIVE   
    RS.PS    (ACTIVE);  // RESET->ACTIVE
    delayMicroseconds(40); // wait 40us after PS->High as recommended in data sheet
	// ready to clock	
}

void loop() 
{

  // multiple clocks using CLK(N)

  //FULL_STEP CCW
  RS.MODE  (FULL_STEP);   
  RS.CW_CCW(CCW); 
  RS.CLK(100);
  
  //QUARTER_STEP CW
  RS.MODE  (QUARTER_STEP); 
  RS.CW_CCW(CW); 
  RS.CLK(400);
    
  // multiple clocks using CLK(1) and a for-statement
  
  int i;
  RS.MODE  (HALF_STEP_A); 
  RS.CW_CCW(CCW); 
  RS.setCLK_Hz(1000); // set up new CLK freq
  for (i=0;i<1000;i++) 
  RS.CLK(1);

  RS.CW_CCW(CW); 
  RS.setCLK_Hz(100);  // set up new CLK freq
  for (i=0;i<1000;i++) 
  RS.CLK(1);
   
  RS.MODE  (HALF_STEP_B);  
  RS.CW_CCW(CCW); 
  RS.setCLK_HP(500);  //set up new value for CLK half period
  for (i=0;i<1000;i++) 
  RS.CLK(1);
 
  RS.CW_CCW(CW); 
  RS.setCLK_HP(5000); //set up new value for CLK half period
  for (i=0;i<1000;i++) 
  RS.CLK(1);

  RS.setCLK_HP(0);    // restore default  value half period 1000 us
 
  delay(1000);
}
