/*
Basic operations. Demo for two boards operating at the same time. 
*/
 
// ROHM IC Motor Drivers
// please define one of the following motor driver ICs
// based on the EVK model version you are using.
// Please also visit
// http://www.rohm.com/web/eu/arduino-stepper-motor-shield
// to download the latest EVK manual version.
// Please also visit
// http://www.rohm.com/web/eu/search/parametric/-/search/Stepping%20Motor
// to download the latest datasheet version of the motor driver IC you are evaluating.

//#define BD63510AEFV  
//#define BD63520AEFV 
//#define BD63524AEFV 
//#define BD63710AEFV  
//#define BD63715AEFV 
#define BD63720AEFV  
//#define BD6425EFV 
//#define BD63843EFV 
//#define BD63847EFV
 
#include <ROHM_Steppers.h>

// initialize the ROHM Steppers libs for MASTER board 
// and NOT ACTIVE(OPEN), RESET, FULL_STEP, CW 
// half clock perid 1000 us by default

ROHM_Stepper RS(TWO);

// TWO boards MASTER or MAIN, SLAVE or SECOND 

void setup()
{
	// change pin state
    RS.ENABLE_M(ACTIVE);  // ASTEROPEN->ACTIVE   
    RS.PS_M    (ACTIVE);  // RESET->ACTIVE
    RS.ENABLE_S(ACTIVE);  // OPEN->ACTIVE   
    RS.PS_S    (ACTIVE);  // RESET->ACTIVE
    delayMicroseconds(40); // wait 40us after PS->High as recommended in data sheet
     // ready to clock	
}

void loop() 
{
  RS.setCLK_Hz(100);

  // Second board SLAVE
  RS.MODE_S  (FULL_STEP); 
  RS.CW_CCW_S(CW); 
  RS.CLK_S(400);

  // Main board MASTER 
  RS.MODE_M  (FULL_STEP); 
  RS.CW_CCW_M(CW); 
  RS.CLK_M(400);
  
   int  i;

  RS.setCLK_Hz(500);
  RS.MODE_M  (QUARTER_STEP); 
  RS.MODE_S  (QUARTER_STEP); 

   // 
   RS.CW_CCW_M(CCW); 
   RS.CW_CCW_S(CW); 

   for (i=0;i<1000;i++)
   { 
    RS.CLK_M(1);
    RS.CLK_S(1); 
   }    

   // 
   RS.CW_CCW_M(CCW); 
   RS.CW_CCW_S(CCW); 

   for (i=0;i<1000;i++)
   { 
    RS.CLK_M(1);
    RS.CLK_S(1); 
   }    

  delay(1000);
}
